#ifndef BICV_HISTOGRAMLIKELIHOOD_INC
#define BICV_HISTOGRAMLIKELIHOOD_INC

#include "general.h"
#include "bf_RandomVariable.h"
#include "bf_RandomGenerator.h"
#include "bf_DistributionReal.h"

#include "bf_RVFunctions.h"

// open cv
#include "cv.h"

#include "ipcv_HistogramTemplate.h"
#include "bi_HistogramMeasurer.h"

using namespace ImageProcessing;

namespace Torch {
  //-----

  /** 

      
    
      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */
  //===================================================
  //
  //    class         bicv_HistogramLikekihood
  //
  //      models   P_Ht (Z|X) = prob( distance(Ht, Hobs(Z,X)))
  //
  //  Ht is a muldimensional histogram template 
  //     (position x features) implemented as a vector of 
  //     Histogram on features
  //  Hobs(Z,X) is an histogram (same size as Ht) observed
  //   by making measurements using the Histogram measurer
  //   in the configuration characterized by the state X
  //
  //===================================================

  class   bicv_HistogramLikelihood : public bf_EvalCondDist {
  public:
    ipcv_HistogramTemplate  *m_pHtemplate;
    bi_HistogramMeasurer    *m_pHmeasurer;
    bf_EvalDistReal         *m_pProb;

    // For extracting transform params from state
    bf_RvToRvFunction               *m_pExtractParams;
    
    // For extracting IplImage** used for histogram 
    // computations
    bf_RvToRvFunction               *m_pExtractIplImages;
 
    // for temporary storage or access
    ipcv_HistogramTemplate  *m_pHobs;
    IplImage               **m_pBands;
    
    //-----
    bicv_HistogramLikelihood(ipcv_HistogramTemplate  *Htemplate,
			     bi_HistogramMeasurer    *Hmeasurer,
			     bf_EvalDistReal         *Prob,
			     bf_RvToRvFunction       *ExtractParams=NULL,
			     bf_RvToRvFunction       *ExtractIplImages=NULL);

    //----
    virtual void  create(ipcv_HistogramTemplate  *Htemplate,
			 bi_HistogramMeasurer    *Hmeasurer,
			 bf_EvalDistReal         *Prob,
			 bf_RvToRvFunction       *ExtractParams=NULL,
			 bf_RvToRvFunction       *ExtractIplImages=NULL);

    //----
    virtual void  freeMemory();
    
    //----
    virtual bf_RandomVariable * extractTransformParams(bf_RandomVariable *pX){
      if (m_pExtractParams==NULL)
	return pX;
      else
	return m_pExtractParams->imageRV(pX);
    }

    //----
    virtual void extractBands(bf_RandomVariable *pZ){
      if(m_pExtractIplImages==NULL)
	m_pBands= (IplImage **) pZ->m_cData.nodes[0];
      else
	m_pBands=  (IplImage **) (m_pExtractIplImages->imageRV(pZ))->m_cData.nodes[0];
    }

    //----
    virtual inline real evaluateConditionalRV(bf_RandomVariable *pZ,bf_RandomVariable *pX){
      real d;
      extractBands(pZ);
      m_pHmeasurer->transformRV(extractTransformParams(pX));
      if(m_pHmeasurer->computeHistogram(m_pBands,m_pHobs)){
	d=m_pHtemplate->distance(m_pHobs);
	return m_pProb->evaluateReal(&d);
      }
      else 
	return 0.;
    }

    //----
    virtual ~bicv_HistogramLikelihood(){ freeMemory();}


  };

   
}

#endif
