#include "bicv_HistogramLikelihood.h"

namespace Torch {
  //-----
  bicv_HistogramLikelihood::bicv_HistogramLikelihood(ipcv_HistogramTemplate *Htemplate,
						     bi_HistogramMeasurer   *Hmeasurer,
						     bf_EvalDistReal        *Prob,
						     bf_RvToRvFunction      *ExtractParams,
						     bf_RvToRvFunction      *ExtractIplImages){
    m_pHtemplate=NULL;
    create(Htemplate,Hmeasurer,Prob,ExtractParams,ExtractIplImages);
  }

  //-----
  void  bicv_HistogramLikelihood::create(ipcv_HistogramTemplate  *Htemplate,
					 bi_HistogramMeasurer    *Hmeasurer,
					 bf_EvalDistReal         *Prob,
					 bf_RvToRvFunction       *ExtractParams,
					 bf_RvToRvFunction       *ExtractIplImages){
    if(m_pHtemplate!=NULL)
      freeMemory();
    m_pHtemplate=Htemplate;
    m_pHmeasurer=Hmeasurer;
    m_pProb=Prob;
    m_pExtractParams=ExtractParams;
    m_pExtractIplImages=ExtractIplImages;

    // create memory for Observation
    m_pHobs=Htemplate->createCopy(true);
    
   }

  //-----
  void  bicv_HistogramLikelihood::freeMemory(){
    if(m_pHobs!=NULL) delete m_pHobs;
  }
  
   
}

