#include "bicv_ContourTracker.h"
#include "bf_UniGaussianWithFactorDistribution.h"
#include "bf_ParticleFilter.h"

#include "general.h"

#ifndef min
/// The min function
#define	min(a,b) ((a) > (b) ? (b) : (a))
#endif

#ifndef max
/// The max function
#define	max(a,b) ((a) > (b) ? (a) : (b))
#endif


using namespace ImageProcessing;

namespace Torch {

  //-----
  // constructors
  bicv_ContourTracker::bicv_ContourTracker(int NberOfParticles,
					   ip_PlanarTransform *pT,
					   int numPtsContour, int measureType,
					   real lineLength, int numPtsSearchLine,
					   ip_Ellipse *pInitEllipse,			
					   bf_DataRandomVariable *pZ,
					   real K, real sigma) :
    bf_Trainer(NULL,pZ) 
  {
    int n,i;
    
    // construct the differents elements of the particle filter
    
    // number of parameters of transform
    n=pT->nbParams();
    
    // the dynamical model.
    real  * Var;
    Var = new real [n];
    for(i=0;i<min(2,n);i++)
      Var[i]=VAR_TRANSLATION;       
    for(i=2;i<n;i++)
      Var[i]=VAR_SCALING;  
    m_pDynamics= new bf_DynamicAR2(n,Var);
    delete [] Var;
    
    // the particles
    m_pRng1=new bf_RandomGenerator(3);
    m_pRng2=new bf_RandomGenerator(2);
    m_pPosteriorDistribution=new bf_MixedParticleDistribution(NberOfParticles,1,
							      m_pDynamics->nbStates(),0,
							      m_pRng1);  
    m_pAuxDistribution=new bf_MixedParticleDistribution(NberOfParticles,1,
							m_pDynamics->nbStates(),0,
							m_pRng2);      
    
    // the contour likelihood    
    // working with measureType 1  
    m_pTemplate= new ipcv_ContourTemplate(numPtsContour,measureType, lineLength, numPtsSearchLine);
    m_pTrans=pT;
    m_pMeasurer=new bicv_TransformedEllipseTemplate;
    m_pMeasurer->create(pInitEllipse,pT,false,true);  
    m_pProbaLikelihood = new bf_UniGaussianWithFactorDistribution(K,0.,sigma);
    m_pLikelihood = new bicv_ContourLikelihood(m_pTemplate,m_pMeasurer, m_pProbaLikelihood);
       
    // create the filter;
    m_pParticleFilter = new bf_ParticleFilter(m_pPosteriorDistribution,
					      m_pAuxDistribution,
					      m_pDynamics,m_pLikelihood);
    m_pBayesFilter = m_pParticleFilter;
  }


  //-----
  void bicv_ContourTracker::init(long N)
  {
    bf_Trainer::init(N);

    //i do not need to initialize anything besides copying pointer to contour template
    m_pMeasurer->transform();

    //-----------
    // need to recover parameters to initialize particles
    real *initpar=new real [m_pDynamics->nbStates()];
    real *initconfig=new real [m_pDynamics->nbStates()]; // indeed less than nbStates is needed
    m_pMeasurer->setStepGet(1);
    m_pMeasurer->getTransformReal(initconfig);
    m_pDynamics->initState(initpar,initconfig);
    
    m_pPosteriorDistribution->setAllSample(initpar,0);

    // IMPORTANT :
    // set which parameters of the state are useful
    // for updating object configuration.

    m_pMeasurer->setStepSet(m_pDynamics->nbStates(0));

    delete [] initconfig;
    delete [] initpar;


  }
  
  //-----
  bicv_ContourTracker::~bicv_ContourTracker()
  {
    delete m_pDynamics;
    delete m_pRng1;
    delete m_pRng2;
    delete m_pPosteriorDistribution;
    delete m_pAuxDistribution;
    delete m_pTemplate;
    delete m_pMeasurer;
    delete m_pProbaLikelihood;
    delete m_pParticleFilter;
  }
  
}

