#include "bicv_ContourLikelihood.h"

namespace Torch {
  //-----
  bicv_ContourLikelihood::bicv_ContourLikelihood(ipcv_ContourTemplate   *pCtemplate,
						 bi_ContourMeasurer *pCmeasurer,
						 bf_EvalDistReal    *pProb,
						 bf_RvToRvFunction  *pExtractParams,
						 bf_RvToRvFunction  *pExtractIplImages)
  {
    m_pCtemplate=NULL;
    create(pCtemplate,pCmeasurer,pProb,pExtractParams,pExtractIplImages);
  }

  //-----
  void bicv_ContourLikelihood::create(ipcv_ContourTemplate   *pCtemplate,
				      bi_ContourMeasurer  *pCmeasurer,
				      bf_EvalDistReal     *pProb,
				      bf_RvToRvFunction   *pExtractParams,
				      bf_RvToRvFunction   *pExtractIplImages)
  {
    if(m_pCtemplate!=NULL)
      freeMemory();
    m_pCtemplate=pCtemplate;
    m_pCmeasurer=pCmeasurer;
    m_pProb=pProb;
    m_pExtractParams=pExtractParams;
    m_pExtractIplImages=pExtractIplImages;    
   }

  //-----
  void bicv_ContourLikelihood::freeMemory()
  {}     

  //----
  bf_RandomVariable* bicv_ContourLikelihood::extractTransformParams(bf_RandomVariable *pX)
  {
    if (m_pExtractParams==NULL)
      return pX;
    else
      return m_pExtractParams->imageRV(pX);     //IMPORTANT: this function returns pX anyway !!
  }

  //-----
  void bicv_ContourLikelihood::extractBands(bf_RandomVariable *pZ)
  {
    if(m_pExtractIplImages == NULL)
      m_pBands = (ip_Image<ip_ColorElement8u> *) pZ->m_cData.nodes[0];
    else
      m_pBands = (ip_Image<ip_ColorElement8u> *) (m_pExtractIplImages->imageRV(pZ))->m_cData.nodes[0];
  }

  //-----
  real bicv_ContourLikelihood::evaluateConditionalRV(bf_RandomVariable *pZ,bf_RandomVariable *pX)
  {
    
    extractBands(pZ);
    m_pCmeasurer->transformRV(extractTransformParams(pX));

    if(m_pCmeasurer->computeContourMeasurements(m_pBands,m_pCtemplate))
    {
      // specific method to compute the likelihood
      // original: return m_pCtemplate->computeLikelihood(m_pProb);

      // computing the likelihood by introducing a prior on the state space
      real *pCT = new real[m_pCmeasurer->nbParam()];
      m_pCmeasurer->getTransformReal(pCT);
      real priorProb = priorOnStates(pCT, m_pCmeasurer->nbParam());
      delete[] pCT;
      return m_pCtemplate->computeLikelihood(m_pProb) * priorProb;
    }
    else
      return 0.;
  }

  //-----
  // quick and dirty implementation, parameters in bi_ParsContourTracking.h
  real bicv_ContourLikelihood::priorOnStates(real *pPars, int dim)
  {
    for(int i=2; i<dim; i++)
      if(pPars[i] < MINIMUM_SCALING || pPars[i] > MAXIMUM_SCALING)
	return 0.;
    return 1.;

  }


}



