#include "bicv_ContourAndHistogramTracker.h"
#include "bf_ExponentialDistribution.h"
#include "bf_ParticleFilter.h"
#include "bf_LikelihoodProduct.h"
#include "bi_PlanarTransformStateLikelihood.h"

#include "bicv_ContourTracker.h"
#include "bf_UniGaussianWithFactorDistribution.h"


using namespace ImageProcessing;

namespace Torch {

  //================================================================

  //-- constructors
  bicv_ContourAndHistogramTracker::bicv_ContourAndHistogramTracker(int NberOfParticles, 
								   ip_PlanarTransform *T,
								   // which likelihood
								   int  LikelihoodModel,
								   // DYNAMICS
								   real DynamicsTranslationStdev,
								   real DynamicsAffineStdev,
								   // HISTOGRAM PARAMETERS
								   int SplitHeight,int SplitWidth,
								   int  DIM_C,
								   real Lambda,real Z, // parameters of the likelihood
								   // for the histogram
								   int  number_of_bands, // numbers of band to take 
								   // into account for histogram computation 
								   // SHAPE PARAMETERS
								   int numPtsContour, int measureType,
								   real lineLength, int numPtsSearchLine,
								   real K, real sigma,
								   // INITIAL POSITION
								   ip_BoundingBox   initBB,
								   // DATA
								   bf_DataRandomVariable *pZ
								   )
    :  bf_Trainer(NULL,pZ) {
    int n,i,likenumber;
    
    m_iNumberOfBands=number_of_bands;
    
    // construct the differents elements of the particle filter
    
    // number of parameters of transform
    n=T->nbParams();
    
    // the dynamical model.
    real  * Var;
    Var = new real [n];
    for(i=0;i<min(2,n);i++)
      Var[i]=DynamicsTranslationStdev*DynamicsTranslationStdev;
    for(i=2;i<n;i++)
      Var[i]=DynamicsAffineStdev*DynamicsAffineStdev;
    
    // m_pDynamics= new bf_DynamicAR2(n,Var);
    m_pDynamics= new bf_DynamicAR3(n,Var);
    delete [] Var;
    
    // the particles
    m_pRng1=new bf_RandomGenerator(3);
    m_pRng2=new bf_RandomGenerator(2);
    m_pPosteriorDistribution=new bf_MixedParticleDistribution(NberOfParticles,1,
							      m_pDynamics->nbStates(),0,
							      m_pRng1);  
    m_pAuxDistribution=new bf_MixedParticleDistribution(NberOfParticles,1,
							m_pDynamics->nbStates(),0,
							m_pRng2);      
    
    // The likelihoods
    m_pTrans=T;
    //
    m_cInitBB=initBB;
    
    // prepare for the multiplicative likelihoods
    int  Tab[4]; 
    m_iNumberOfLikelihood=0;
    if(LikelihoodModel & LIKELIHOOD_HISTO){
      m_iLikeHisto=1;
      m_iNumberOfLikelihood++;
    }
    else {
      m_iLikeHisto=0;
    }
    
    if(LikelihoodModel & LIKELIHOOD_CONTOUR){
      m_iLikeContour=1;
      m_iNumberOfLikelihood++;
    }
    else {
      m_iLikeContour=0;
    }
    
    if(T->planarModel()==PLANAR_TRANSLATION_SCALING2 || 
       T->planarModel()==PLANAR_TRANSLATION_SCALING  )
      m_iNumberOfLikelihood++;
    
    m_pLikelihoodTable = new bf_EvalCondDist * [m_iNumberOfLikelihood];
    // order of likelihoods (if chosen): 
    //     1. histogram            data in pointer : 0
    //     2. contour              data in pointer : 1
    //     3. state likelihood(if necessary)  data in pointer : 0 (but not used by state likelihood)
    if(T->planarModel()==PLANAR_TRANSLATION_SCALING2 ||
       T->planarModel()==PLANAR_TRANSLATION_SCALING  )
      {
	bi_PlanarTransformStateLikelihood *pL;
	pL=new bi_PlanarTransformStateLikelihood(T->planarModel(),
						 m_pDynamics->nbStates(0));
	m_pLikelihoodTable[m_iNumberOfLikelihood-1]=pL;
	Tab[m_iNumberOfLikelihood-1]=0; 
	if(T->planarModel()==PLANAR_TRANSLATION_SCALING2){
	  pL->m_rRatioScaleMax=1.1;
	}
	
      }
    
    
    likenumber=0;
    // ALWAYS CREATE THE MEASURERS SO THAT WE CAN DRAW IT
    
    // The HISTOGRAM LIKELIHOOD
    
    int nbpos=SplitWidth*SplitHeight;
    m_pHistoMeasurer=new bicv_ChessBoardTemplate ;
    m_pHistoMeasurer->create(SplitWidth,SplitHeight,T);
    
    if(m_iLikeHisto>0){
      // working on m_iNumberOfBands bands, with a range of [0.255], and 
      // DIM_C boxe per axis
      m_pHistoTemplate= new ipcv_HistogramTemplate(nbpos,m_iNumberOfBands,
						   DIM_C,0.,255.);
      // 
      m_pHistoProbaLikelihood = new bf_ExponentialDistribution(Lambda,Z);
      m_pHistoLikelihood = new  bicv_HistogramLikelihood(m_pHistoTemplate,
							 m_pHistoMeasurer,
							 m_pHistoProbaLikelihood);
      m_pLikelihoodTable[likenumber] = m_pHistoLikelihood;
      Tab[likenumber]=0;
      likenumber++;
    }
    
    // The CONTOUR LIKELIHOOD
    m_pContourMeasurer=new bicv_TransformedEllipseTemplate;
    // 
    if(m_iLikeContour>0){
      m_pContourTemplate= new ipcv_ContourTemplate(numPtsContour,measureType, 
						   lineLength, numPtsSearchLine);
      
      m_pContourProbaLikelihood = new bf_UniGaussianWithFactorDistribution(K,0.,sigma);
      m_pContourLikelihood = new bicv_ContourLikelihood(m_pContourTemplate,
							m_pContourMeasurer, 
							m_pContourProbaLikelihood);
      m_pLikelihoodTable[likenumber] = m_pContourLikelihood;
      Tab[likenumber]=1;
      likenumber++;
    }
    
    /*   // THE BACKGROUND LIKELIHOOD
    //----------------------------
    int SplitWidthBackG=1,SplitHeightBackG=1;
    int nbposBack=SplitWidthBackG*SplitHeightBackG;
    
    m_pBackgroundMeasurer=new bicv_CouronneTemplate ;
    m_pBackgroundMeasurer->create(SplitWidthBackG,SplitHeightBackG,T);
    
    if(m_iLikeBackground>0){
      // working on m_iNumberOfBands bands, with a range of [0.255], and DIM_C boxe per axis
      m_pBackgroundTemplate= new ipcv_HistogramTemplate(nbposBack,m_iNumberOfBands,
							DIM_C,0.,255.);
      // WE TEST THE RATIO OF LIKELIHOODS
      float  ratio=3;
      
      m_pBackgroundProbaLikelihood = new bf_ExponentialDistribution(-Lambda/ratio,Z);
      m_pBackgroundHistogramLikelihood =  new  bicv_HistogramLikelihood(m_pBackgroundTemplate,
									m_pBackgroundMeasurer,
									m_pBackgroundProbaLikelihood);
      m_pLikelihoodTable[likenumber] = m_pBackgroundHistogramLikelihood;
      Tab[likenumber]=0;
      likenumber++;
    }

    */
    

    // the GLOBAL LIKELIHOOD
    m_pLikelihood = new bf_LikelihoodProduct(m_pLikelihoodTable,Tab,m_iNumberOfLikelihood);
    
    
    // finally, lets create the filter;
    m_pParticleFilter = new bf_ParticleFilter(m_pPosteriorDistribution,
					      m_pAuxDistribution,
					      m_pDynamics,m_pLikelihood);

    m_pBayesFilter = m_pParticleFilter;

  }

  //================================================================

  //-- 
  void bicv_ContourAndHistogramTracker::init(long N){
    bf_Trainer::init(N);
    
   //-----------
    // need to recover parameters to initialize particles
    real *initpar=new real [m_pDynamics->nbStates()];
    real *initconfig=new real [m_pDynamics->nbStates()];// indeed less than nbStates is needed
    
    
    //--------------------
    // Histogram likelihoo
    //--------------------
    real   percent=1.;
    
    ip_BoundingBox  Binit;
    Binit.initPosAndSize(m_cInitBB.firstColumn()+(int)(0.5+m_cInitBB.width()*(1.-percent)/2.),
			 m_cInitBB.firstLine()+(int)(0.5+m_cInitBB.height()*(1.-percent)/2.),
			 (int)(m_cInitBB.width()*percent+0.5),
			 (int)(m_cInitBB.height()*percent+0.5));
    
    m_pHistoMeasurer->setSurroundingBB(Binit,true);
    // we initialize all particle from the histogram configuration
    m_pHistoMeasurer->transform();
    m_pHistoMeasurer->setStepGet(1);
    m_pHistoMeasurer->getTransformReal(initconfig);
    m_pDynamics->initState(initpar,initconfig);
    m_pPosteriorDistribution->setAllSample(initpar,0);
    // IMPORTANT :
    // set which parameters of the state are usefull
    // for updating object configuration.
    m_pHistoMeasurer->setStepSet(m_pDynamics->nbStates(0));
    
    if(m_iLikeHisto>0){
      // we need to initialize the template image
      m_pHistoMeasurer->computeHistogram((IplImage **)m_pDataInput->m_cData.nodes[0],m_pHistoTemplate);
      printf("Initial histogram computed.\n"); fflush(stdout);
    }

    //-------------------
    // Contour likelihood
    ip_Ellipse               myEllipse;
    real cX,cY,semiX,semiY,angle=0.;
    cX=(m_cInitBB.lastColumn()+m_cInitBB.firstColumn())/2.-0.5;
    cY=(m_cInitBB.lastLine()+m_cInitBB.firstLine())/2.-0.5;
    semiX=m_cInitBB.width()/2.;
    semiY=m_cInitBB.height()/2.;
    
    myEllipse.init(cX,cY,semiX,semiY,angle);
    m_pContourMeasurer->create(&myEllipse,m_pTrans,true,true);  
    // not necessary normally
    m_pContourMeasurer->transform();
    
    m_pContourMeasurer->setStepGet(1);
    // IMPORTANT :
    // set which parameters of the state are usefull
    // for updating object configuration.
    m_pContourMeasurer->setStepSet(m_pDynamics->nbStates(0));
    
    /*
 
    //--------------------------------
    // Background Histogram likelihood
    //---------------------------------
    // uses Binit defined for histogram
    // initialize template for background
    m_pBackgroundMeasurer->setInsideBB(m_cInitBB,2.,1.3,true);
    m_pBackgroundMeasurer->transform();
    
    if(m_iLikeBackground>0){
      // we need to initialize the template image
      // we compute the template in the object region
      bicv_ChessBoardTemplate *		hMeasurer;
      hMeasurer = new bicv_ChessBoardTemplate;
      // DANGER : because we use the m_pTrans, the set step here is initialized
      // to one (in bicv_BoundingBoxTemplate) (I have modified it since then)
      hMeasurer->create(m_pBackgroundMeasurer->m_iNbSplitCo,
			m_pBackgroundMeasurer->m_iNbSplitLi,m_pTrans);
      hMeasurer->setSurroundingBB(Binit,true);
      hMeasurer->transform();
      
      //  m_pHistoMeasurer->computeHistogram((IplImage **)m_pDataInput->m_cData.nodes[0],m_pHistoTemplate);
      hMeasurer->computeHistogram((IplImage **)m_pDataInput->m_cData.nodes[0],
				  m_pBackgroundTemplate);
      
      delete hMeasurer;
    }
    // IMPORTANT :
    // set which parameters of the state are usefull
    // for updating object configuration.

    // IMPORTANT : DO THIS (OR ANOTHER SET STEP) AT THE END
    m_pBackgroundMeasurer->setStepSet(m_pDynamics->nbStates(0));

    */

    m_pHistoMeasurer->setStepSet(m_pDynamics->nbStates(0));
	 
    //-------------------------------
    delete [] initconfig;
    delete [] initpar;
    
    
  }
  
  //================================================================
  
  bicv_ContourAndHistogramTracker::~bicv_ContourAndHistogramTracker(){
    int i;
    delete m_pDynamics;
    delete m_pRng1;
    delete m_pRng2;
    delete m_pPosteriorDistribution;
    delete m_pAuxDistribution;

    delete m_pHistoMeasurer;
    if(m_iLikeHisto>0){
      delete m_pHistoTemplate;
      delete m_pHistoProbaLikelihood;
      // HistoLikelihood will be destroyed from the table
    }
    
    delete m_pContourMeasurer;
    if(m_iLikeContour){
      delete m_pContourTemplate;
      delete m_pContourProbaLikelihood;
    }
    
    /*	 
	delete m_pBackgroundMeasurer;
	if(m_iLikeBackground>0){
	delete m_pBackgroundTemplate;
	delete m_pBackgroundProbaLikelihood;
	// m_pBackgroundHistogramLikelihood will be destroyed from the table
	}
	
    */
    
    delete m_pParticleFilter;
    delete m_pLikelihood;

    if(m_iNumberOfLikelihood>0){
      for(i=0;i<m_iNumberOfLikelihood;i++)
	delete m_pLikelihoodTable[i];
      delete [] m_pLikelihoodTable;
    }
    
  }
  
}
