#include "bicv_BoundingBoxesTemplate.h"
#include "macros.h" // for MyArrondi

using namespace ImageProcessing;

namespace Torch {
  //			 ip_PlanarTransform *m_pTransform,
  //		 int                 m_iNbBBoxes,
  //		 bool AllocateMemTemp=true);


  //-----
  bicv_BoundingBoxesTemplate::bicv_BoundingBoxesTemplate(): 
    m_pBBTemplate(NULL),
    m_pBBCurrent(NULL),
    m_pTransform(NULL),
    m_bTemplateAllocated(false),
    m_iNbBBoxes(0),
    m_pVolumeOfBoxes(NULL),
    m_iStepGet(1) {
  }
  
  //-----
  bicv_BoundingBoxesTemplate::bicv_BoundingBoxesTemplate(int NbBBoxes,
							 ip_PlanarTransform *Transf,
							 bool AllocateMemTemp): 
    m_pBBTemplate(NULL),
    m_pBBCurrent(NULL),
    m_pTransform(Transf), 
    m_bTemplateAllocated(AllocateMemTemp),
    m_iNbBBoxes(NbBBoxes),
    m_pVolumeOfBoxes(NULL),
    m_iStepGet(1) 
  {
    setStepSet(1);
    create(NULL,Transf,NbBBoxes,AllocateMemTemp);
  }
  
  //-----
  bicv_BoundingBoxesTemplate::bicv_BoundingBoxesTemplate(ip_BoundingBox   *BBTemplate,
							 int NbBBoxes,
							 ip_PlanarTransform *Transf,
							 bool AllocateMemTemp,
							 bool  with_center): 
    m_pBBTemplate(NULL),
    m_pBBCurrent(NULL),
    m_pTransform(Transf),
    m_bTemplateAllocated(AllocateMemTemp),
    m_iNbBBoxes(NbBBoxes),
    m_pVolumeOfBoxes(NULL),
    m_iStepGet(1){

    setStepSet(1);
    create(BBTemplate,Transf,NbBBoxes,AllocateMemTemp,with_center);
  }
  
  //----
  void  bicv_BoundingBoxesTemplate::create(ip_BoundingBox   *BBTemplate,
					   ip_PlanarTransform *Transf,
					   int                 NbBBoxes,
					   bool AllocateMemTemp,
					   bool  with_center){
    if(m_pTransform!=NULL){
      Transf->m_iStepRead=m_pTransform->m_iStepRead;
    }
	 //    else 
	 // Transf->m_iStepRead=1;

    m_pTransform=Transf;
    if(m_pBBCurrent!=NULL)
      freeMemory();
    m_iNbBBoxes=NbBBoxes;
    
    m_pBBCurrent=new ip_BoundingBox [NbBBoxes];
    m_bTemplateAllocated=AllocateMemTemp;
    if(m_bTemplateAllocated) {
      m_pBBTemplate=new ip_BoundingBox [NbBBoxes];
    }
    m_pVolumeOfBoxes=new int [NbBBoxes];

    setBB(BBTemplate,with_center);

  }

  //----
  ip_Pixel   bicv_BoundingBoxesTemplate::computeCenter(){
    int i;
    int sumli=0,sumco=0;

    if(m_pBBTemplate!=NULL){
      for(i=0;i<m_iNbBBoxes;i++){
		  sumli+= m_pBBTemplate[i].firstLine()+m_pBBTemplate[i].lastLine()-1;
		  sumco+= m_pBBTemplate[i].firstColumn()+m_pBBTemplate[i].lastColumn()-1;
      }
      sumli=(sumli+1)/(2*m_iNbBBoxes); sumco=(sumco+1)/(2*m_iNbBBoxes);
      return ip_Pixel(sumco,sumli);
    }
    else
      return ip_PixelNil;
  }

  //----
  ip_Pixel   bicv_BoundingBoxesTemplate::getCenter(){
    return m_cCenter;
  }

  //----
  void   bicv_BoundingBoxesTemplate::center(){
    int i;

    m_cCenter=computeCenter();

    if(m_pBBTemplate!=NULL){
      m_pTransform->setIdentity(); // usefull line ?
      // translation to compensate for the center location
      for(i=0;i<m_iNbBBoxes;i++){
		  m_pBBTemplate[i].translate(-m_cCenter.m_iCo,-m_cCenter.m_iLi);
      }
      // change transform in order to translate in
      // the other direction
      m_pTransform->translate(m_cCenter.m_iCo,m_cCenter.m_iLi);
    }

  }


  //----
  void   bicv_BoundingBoxesTemplate::setBB(ip_BoundingBox   *BBTemplate,
					   bool with_center){
    if(m_bTemplateAllocated && BBTemplate!=NULL){
      int i;
      for(i=0;i<m_iNbBBoxes;i++)
		  m_pBBTemplate[i]=BBTemplate[i];
    }
    else {
      if(BBTemplate!=NULL)
		  m_pBBTemplate=BBTemplate;
    }
	 
    if(with_center)
      center();
    else {
      m_pTransform->setIdentity();
    }
    transform();
      
  }

  //----
  ip_BoundingBox  bicv_BoundingBoxesTemplate::transformBB(ip_BoundingBox & BBin){
    ip_Point im;
    ip_BoundingBox ans,oneBB;
    int l,c;

    im=m_pTransform->imageReal(BBin.firstColumn(),BBin.firstLine());
    l=MyArrondi(im.m_rY);    c=MyArrondi(im.m_rX);
    ans.initPosAndSize(c,l,1,1);
    im=m_pTransform->imageReal(BBin.firstColumn(),BBin.lastLine()-1);
    l=MyArrondi(im.m_rY);    c=MyArrondi(im.m_rX);
    oneBB.initPosAndSize(c,l,1,1);
    ans.outerBoundingBox(oneBB);
    im=m_pTransform->imageReal(BBin.lastColumn()-1,BBin.lastLine()-1);
    l=MyArrondi(im.m_rY);    c=MyArrondi(im.m_rX);
    oneBB.initPosAndSize(c,l,1,1);
    ans.outerBoundingBox(oneBB);
    im=m_pTransform->imageReal(BBin.lastColumn()-1,BBin.firstLine());
    l=MyArrondi(im.m_rY);    c=MyArrondi(im.m_rX);
    oneBB.initPosAndSize(c,l,1,1);
    ans.outerBoundingBox(oneBB);

    return ans;

  }

  //----
  // from bi_ShapeTransformTemplate
  void bicv_BoundingBoxesTemplate::transform(void){
    int i;
    if(m_pBBTemplate!=NULL)
      for(i=0;i<m_iNbBBoxes;i++)
	m_pBBCurrent[i]=transformBB(m_pBBTemplate[i]);
    else {
      printf("\n WARNING : NOT BOUNDING BOX TEMPLATE SET YET \n\n");
      fflush(stdout);
      exit(0);
    }      
  }


  //----
  // from HistogramMeasurer
  bool  bicv_BoundingBoxesTemplate::computeHistogram(IplImage **bands,
						     ipcv_HistogramTemplate *H){
    int i,b,N,N2;
    ip_BoundingBox  ImageBB;
    ip_BoundingBox  Work;

    CvRect          ROI;
    
 
    if(m_iNbBBoxes>0)
      ImageBB.initPosAndSize(0,0,bands[0]->width,bands[0]->height);

    
    N=0; N2=0;
    for(i=0;i<m_iNbBBoxes;i++){
      Work=m_pBBCurrent[i];
      N2+=Work.area();
      Work.intersection(ImageBB);    // crop to stay in image range
		
      //      Work.display("Work :"); fflush(stdout);
      m_pVolumeOfBoxes[i]=Work.area();
		
		// Work.display("In Bounding Box Template\n");
		
		
      N+=m_pVolumeOfBoxes[i];
      if(m_pVolumeOfBoxes[i]>0){
		  ROI.x=Work.m_iFirstColumn;
		  ROI.y=Work.m_iFirstLine;
		  ROI.width=Work.m_iWidth;
		  ROI.height=Work.m_iHeight;
		  for(b=0;b<H->m_iNbBands;b++){
			 cvSetImageROI(bands[b],ROI);
		  }
		  cvCalcHist(bands,H->m_pHt[i],0,0);
      }
    }
    // Normalize histogram to get a "full" multivariate histogram
    for(i=0;i<m_iNbBBoxes;i++)
      cvNormalizeHist(H->m_pHt[i],(float)m_pVolumeOfBoxes[i]/N);
	 
    // we set a limit on the numbers of points we 
    // need (this should be compared with the total number
    // of bins in the template)
    if((double)N/(double)N2 < 0.5 || N < 500 )
      return false;
    else 
      return true;
  }

  //----
  void   bicv_BoundingBoxesTemplate::draw(ip_Image<ip_ColorElement8u> &Ima,
					  ip_ColorElement8u color,bool current){
    int i;
    if(current)
      for(i=0;i<m_iNbBBoxes;i++){
	m_pBBCurrent[i].draw(Ima,color,2);
      }
    else
      for(i=0;i<m_iNbBBoxes;i++){
	m_pBBTemplate[i].draw(Ima,color,2);
      }


  }

  //----
  void   bicv_BoundingBoxesTemplate::draw(ip_Image<uchar> &Ima,
					  uchar color,bool current){
    int i;
    if(current)
      for(i=0;i<m_iNbBBoxes;i++){
	m_pBBCurrent[i].draw(Ima,color,2);
      }
    else
      for(i=0;i<m_iNbBBoxes;i++){
	m_pBBTemplate[i].draw(Ima,color,2);
      }


  }

  //----
  void  bicv_BoundingBoxesTemplate::freeMemory(){
    if(m_pVolumeOfBoxes!=NULL){
      //      printf("m_pVolumeOfBoxes!=NULL\n"); fflush(stdout);
      delete [] m_pVolumeOfBoxes;
      m_pVolumeOfBoxes=NULL;
    }
    if(m_bTemplateAllocated && m_pBBTemplate!=NULL){
      // printf("m_bTemplateAllocated true \n"); fflush(stdout);
      delete [] m_pBBTemplate;
		m_pBBTemplate=NULL;
    }
    if(m_pBBCurrent!=NULL){
      // printf("m_pBBCurrent!=NULL \n"); fflush(stdout);
      delete [] m_pBBCurrent;
      m_pBBCurrent=NULL;
    }
  }


   
}

