#include "bicv_BoundingBoxesSetTemplate.h"
#include "macros.h" // for MyArrondi

using namespace ImageProcessing;

#define DEBUG 0

namespace Torch {


  //-----
  bicv_BoundingBoxesSetTemplate::bicv_BoundingBoxesSetTemplate(): 
	 bicv_BoundingBoxesTemplate(),
	 m_iNberOfDimensions(0),
    m_pNbBBoxesPerDimension(NULL)
  {  }
  
  //-----
  bicv_BoundingBoxesSetTemplate::bicv_BoundingBoxesSetTemplate(int NbBBoxes,
							 ip_PlanarTransform *Transf,
							 bool AllocateMemTemp): 
	 bicv_BoundingBoxesTemplate(NbBBoxes,Transf,AllocateMemTemp)
  {
	 createNbBBoxesPerDim(NbBBoxes,NbBBoxes);
  }
  
  //-----
  bicv_BoundingBoxesSetTemplate::bicv_BoundingBoxesSetTemplate(ip_BoundingBox   *BBTemplate,
							 int NbBBoxes,
							 ip_PlanarTransform *Transf,
							 bool AllocateMemTemp,
							 bool  with_center): 
	 bicv_BoundingBoxesTemplate(BBTemplate,NbBBoxes,Transf,AllocateMemTemp,with_center)
  {
	 createNbBBoxesPerDim(NbBBoxes,NbBBoxes);
  }
  
  //----
  void  bicv_BoundingBoxesSetTemplate::create(ip_BoundingBox   *BBTemplate,
					   ip_PlanarTransform *Transf,
					   int                 NbBBoxes,
					   bool AllocateMemTemp,
					   bool  with_center){
	 bicv_BoundingBoxesTemplate::create(BBTemplate,Transf,NbBBoxes,AllocateMemTemp,with_center);
	 createNbBBoxesPerDim(NbBBoxes,NbBBoxes);
  }

  //----
  void  bicv_BoundingBoxesSetTemplate::create(ip_BoundingBox   *BBTemplate,
													  ip_PlanarTransform *Transf,
													  int                 NbBBoxes,
													  int                 NbDim,
													  int                *nbBoxPerDim,
													  bool AllocateMemTemp,
													  bool with_center)
  {
	 bicv_BoundingBoxesTemplate::create(BBTemplate,Transf,NbBBoxes,AllocateMemTemp,
											 with_center);
	 createNbBBoxesPerDim(NbBBoxes,NbDim,nbBoxPerDim);
  }
  
  //----
  // create (and copy from input) the distribution of boxes over the dimensions
  // if nbboxes==nbdim, assumes one box per dim
  void   bicv_BoundingBoxesSetTemplate::createNbBBoxesPerDim(int nbboxes,int nbdim,
																	  int *nbBoxPerDim)
  {
	 int i,ntot;
	 
	 if(nbboxes==nbdim){
		if(m_pNbBBoxesPerDimension!=NULL)
		  delete [] m_pNbBBoxesPerDimension;
		m_pNbBBoxesPerDimension=new int [nbdim];
		for(i=0;i<nbdim;i++) m_pNbBBoxesPerDimension[i]=1;
		m_iNberOfDimensions=nbdim;
		return;
	 }
	 
 
	 if(nbdim>nbboxes){
		printf("BoundingBoxesSetTemplate : nber of dimension can not exceed nber of bboxes\n");
		fflush(stdout);
		exit(1);
	 }
	 
	 if(nbdim<nbboxes){
		if(nbBoxPerDim==NULL){
		  printf("BoundingBoxesSetTemplate : no table of dim per boxe provided\n");
		  fflush(stdout);
		  exit(1);
		}
		else{
		  m_iNberOfDimensions=nbdim;
		  if(m_pNbBBoxesPerDimension!=NULL)
			 delete [] m_pNbBBoxesPerDimension;
		  m_pNbBBoxesPerDimension=new int [nbdim];
		  ntot=0;
		  for(i=0;i<nbdim;i++) {
			 m_pNbBBoxesPerDimension[i]=nbBoxPerDim[i];
			 ntot+=nbBoxPerDim[i];
		  }
		  if(ntot!=nbboxes){
			 printf("BoundingBoxesSetTemplate : total of dim per != nb of boxes\n");
			 fflush(stdout);
			 exit(1);
		  }
		  return;
		}
	 }
  }
  


  //----
  // from HistogramMeasurer
  bool  bicv_BoundingBoxesSetTemplate::computeHistogram(IplImage **bands,
																	  ipcv_HistogramTemplate *H){
    int idim,ibox,i,b,N,N2;
    ip_BoundingBox  ImageBB;
    ip_BoundingBox  Work;
	 int             *pVolumeOfBoxes;
	 
    CvRect          ROI;


	 // table should be sufficiently large, since nb BBoxes > nbDimensions
	 pVolumeOfBoxes=getPVolumeOfBoxes();
	 
#if DEBUG>0
	 printf("BoundingBoxesSetTemplate : computeHistogram\n");
	 fflush(stdout);
#endif

    if(nbBBoxes()>0)
      ImageBB.initPosAndSize(0,0,bands[0]->width,bands[0]->height);

    
    N=0; N2=0;
    ibox=0;
	 for(idim=0;idim<m_iNberOfDimensions;idim++){
		int notcleared=1;
		
		pVolumeOfBoxes[idim]=0;
#if DEBUG>1
	 printf("BoundingBoxesSetTemplate : NbBBoxes/dim[%d] = %d\n",idim,
			  m_pNbBBoxesPerDimension[idim]);
	 fflush(stdout);
#endif
		for(i=0;i<m_pNbBBoxesPerDimension[idim];i++){
		  int SizeCurBBox;


		  Work=m_pBBCurrent[ibox];

#if DEBUG>2
		        Work.display("Work after intersection with image:"); fflush(stdout);
#endif


		  N2+=Work.area();
		  Work.intersection(ImageBB);    // crop to stay in image range
		
#if DEBUG>2
		        Work.display("Work after intersection with image:"); fflush(stdout);
#endif

		  SizeCurBBox= Work.area();
		  
		  pVolumeOfBoxes[idim] += SizeCurBBox;
		  
		  N+=SizeCurBBox;
		  if(SizeCurBBox>0){
			 ROI.x=Work.m_iFirstColumn;
			 ROI.y=Work.m_iFirstLine;
			 ROI.width=Work.m_iWidth;
			 ROI.height=Work.m_iHeight;
			 for(b=0;b<H->m_iNbBands;b++){
				cvSetImageROI(bands[b],ROI);
			 }
			 if(notcleared==1){ // clear histogram before computation
				cvCalcHist(bands,H->m_pHt[idim],0,0);
				notcleared=0;
			 }
			 else // update histogram
				cvCalcHist(bands,H->m_pHt[idim],1,0);
		  }

		  // next bbox
		  ibox++;
		}
	 }
	 
    // Normalize histogram to get a "full" multivariate histogram
	 for(idim=0;idim<m_iNberOfDimensions;idim++){
      cvNormalizeHist(H->m_pHt[idim],(float)pVolumeOfBoxes[idim]/N);
	 }

    // we set a limit on the numbers of points we 
    // need (this should be compared with the total number
    // of bins in the template)
    if((double)N/(double)N2 < 0.5 || N < 500 )
      return false;
    else 
      return true;
	 
  }
	 

  //----
  void  bicv_BoundingBoxesSetTemplate::freeMemory(){

	 bicv_BoundingBoxesTemplate::freeMemory();

    if(m_pNbBBoxesPerDimension!=NULL){
      //      printf("m_pNbBBoxesPerDimension!=NULL\n"); fflush(stdout);
      delete [] m_pNbBBoxesPerDimension;
		m_pNbBBoxesPerDimension=NULL;
    }
  }
  

   
}

