#ifndef BI_SHAPE_TRANSFORM_TEMPLATE_INC
#define BI_SHAPE_TRANSFORM_TEMPLATE_INC

#include "general.h"
#include "bf_RandomVariable.h"

namespace Torch {

//-----

/** Provides the interface for a shape template
    with an associated transformation. 

    @author Jean-Marc Odobez (Jean-Marc.Odobez@idiap.ch)
    @author Daniel Gatica-Perez (gatica@idiap.ch)
*/

  class bi_ShapeTransformTemplate
  {   
    public:
      
    //member functions 

    //-----
    bi_ShapeTransformTemplate();
	  
    //-----
    virtual void init();

    //----- tells whether the configuration space is made only
    //      of real parameters (and int)
    virtual bool isReal() = 0;
    
    //----- Number of parameter in the configuration space
    virtual int   nbParam()=0;

    //----- 
    virtual void setTransformReal(real *pTrPars) = 0;

    //----- recover the current configuration of the object
    virtual void getTransformReal(real *pTrPars) = 0;

    //----- dgp: recover the pointer to current configuration of the object
    virtual real *getTransformReal(void) = 0;

    //----- extract the pars from RV
    virtual void setTransformRV(bf_RandomVariable *pRV);

    //-----assuming that setTransform() was used first 
    virtual void transform(void) = 0;

    //-----providing the transform on-the-fly
    virtual void transformReal(real *pTrPars);

    //-----version for random variable
    virtual void transformRV(bf_RandomVariable *pRV);

    //-----
    virtual ~bi_ShapeTransformTemplate();

  };





}

#endif // BI_SHAPE_TRANSFORM_TEMPLATE_INC
