#ifndef BI_SHAPE_INC
#define BI_SHAPE_INC

#include "general.h"
#include "Vec.h"
#include "Mat.h"
#include "bi_Shape.h"



namespace Torch {

//-----

/** Provides the interface for "parameterized" primal shapes
    

    @author Jean-Marc Odobez (Jean-Marc.Odobez@idiap.ch)
    @author Daniel Gatica-Perez (gatica@idiap.ch)
*/


  class bi_Shape
  {
    public:
      
    //members


    Vec  **m_pPointList;           // the shape can be represented by a 
                                   // list of 2-D points 
                                   // OR
                                   // by a set of parameters (not defined here)
    int   m_iNumberOfPoints;   
    int   m_iNumberOfPars;         // number of parameters that define shape 
                                   // for instance, bounding box/ellipse 
                                   //require length and width

    //member functions 

    //-----
    bi_Shape();

    //-----
    virtual void init(int NumberOfPars, int NumberOfPoints);

    //-----
    virtual void samplePoints(void) = 0;

    //-----
    virtual ~bi_Shape();


  };


}

#endif // BI_SHAPE_INC
