#ifndef BI_PLANAR_TRANSFORM_STATE_LIKELIHOOD_INC
#define BI_PLANAR_TRANSFORM_STATE_LIKELIHOOD_INC


#include "ip_PlanarTransform.h"
#include "bf_ExponentialDistribution.h"
#include "bf_DistributionReal.h"

using namespace ImageProcessing;


#define        DEFAULT_SCALE_MIN  0.5
#define        DEFAULT_SCALE_MAX  2.0

#define        DEFAULT_SCALEX_MIN  0.5
#define        DEFAULT_SCALEX_MAX  2.0
#define        DEFAULT_SCALEY_MIN  0.5
#define        DEFAULT_SCALEY_MAX  2.0

#define        DEFAULT_RATIO_SCALE_MAX  1.5


namespace Torch {

  class bi_PlanarTransformStateLikelihood : virtual public bf_EvalCondDistReal {
  public:
    ip_PlanarTransformModel  m_tTransformModel;
    int                      m_iStepRead;

    // in case of unform  scaling
    real                     m_rScaleMin;
    real                     m_rScaleMax;

    // in case of scaling in both direction
    real                     m_rScaleXMin;
    real                     m_rScaleXMax;
    real                     m_rScaleYMin;
    real                     m_rScaleYMax;
    real                     m_rRatioScaleMax;

    

    
    bi_PlanarTransformStateLikelihood(ip_PlanarTransformModel model,int stepread=1);
    

    virtual real evaluateConditionalReal(real *pY,real *pX);


    virtual ~bi_PlanarTransformStateLikelihood();
    
  };

}

#endif
