#include "bi_PlanarTransformStateLikelihood.h"

using namespace ImageProcessing;

namespace Torch {


  //================================================================
  bi_PlanarTransformStateLikelihood::bi_PlanarTransformStateLikelihood(ip_PlanarTransformModel model,
																							  int stepread){
    m_tTransformModel=model;
    m_iStepRead=stepread;

	 m_rScaleMin=DEFAULT_SCALE_MIN;
	 m_rScaleMax=DEFAULT_SCALE_MAX;

	 m_rScaleXMin=DEFAULT_SCALEX_MIN;
	 m_rScaleXMax=DEFAULT_SCALEX_MAX;
	 m_rScaleYMin=DEFAULT_SCALEY_MIN;
	 m_rScaleYMax=DEFAULT_SCALEY_MAX;
	 m_rRatioScaleMax=DEFAULT_RATIO_SCALE_MAX;

  }
  
    

  //================================================================
  real bi_PlanarTransformStateLikelihood::evaluateConditionalReal(real *pY,real *pX){
    switch(m_tTransformModel){
    case PLANAR_TRANSLATION_SCALING2:{
      real  w=1.,rx=pX[m_iStepRead*2],ry=pX[m_iStepRead*3];

		// scale in the x direction
      if(rx<m_rScaleXMin) w *= exp(-(rx-m_rScaleXMin)*(rx-m_rScaleXMin));
      else if(rx>m_rScaleXMax) w *= exp(-(rx-m_rScaleXMax)*(rx-m_rScaleXMax));

		// scale in the y direction
      if(ry<m_rScaleYMin) w *= exp(-(ry-m_rScaleYMin)*(ry-m_rScaleYMin));
      else if(ry>m_rScaleYMax) w *= exp(-(ry-m_rScaleYMax)*(ry-m_rScaleYMax));

		// ratio of scales
      rx=rx/ry;
		if(rx<1.) rx=1/rx;
		if(rx>m_rRatioScaleMax) w *= exp(-5.*(rx-m_rRatioScaleMax)*(rx-m_rRatioScaleMax));
      return w;
    }
    break;

    case PLANAR_TRANSLATION_SCALING:{
      real  w=1.,r=pX[m_iStepRead*2];
      if(r<m_rScaleMin) {
		  real irm=1./-m_rScaleMin;
		  r=1./r;
		  w *= exp(-50.*(r-irm)*(r-irm));
		}
      else if(r>m_rScaleMax) w *= exp(-50.*(r-m_rScaleMax)*(r-m_rScaleMax));
		return w;
	 }
	 break;


    default:
      return 1.;
    }
  }
  
  //================================================================
  bi_PlanarTransformStateLikelihood::~bi_PlanarTransformStateLikelihood(){}
  


};
