#ifndef BICV_IP_IMAGES_DATA_RV_Y_INC
#define BICV_IP_IMAGES_DATA_RV_Y_INC

#include "bf_DataRandomVariable.h"
#include "ipcv_BaseSeqImage.h"
#include "bi_IpImagesDataRV.h"


using namespace ImageProcessing;

namespace Torch {

//-----

/** Data random variable that handles ip_Images which
    are transformed for their Y component
		    
    
    @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
    @author Daniel Gatica-Perez (gatica@idiap.ch)
*/

  class bi_IpImagesDataRV_Y : public virtual bi_IpImagesDataRV
    {
    public:
      ipcv_Image<ip_ColorElement8u>        *m_pImageY;

    public:

      ///-----
      bi_IpImagesDataRV_Y(ip_BaseSeqImage<ip_ColorElement8u> *Seq):
	bi_IpImagesDataRV(Seq)
      {
	m_pImageY = new ipcv_Image<ip_ColorElement8u>;
      }

      
      //-----
      virtual void initData(void)
      {	
	m_bDataAvailable = m_pImageSequence->firstImage();

	//creates YUV image
	if(dataAvailable())
	{	  
	  m_pImageY->allocateMem(m_pImageSequence->currentImage()->nbLines(),
				 m_pImageSequence->currentImage()->nbColumns());
	}

	if(m_pData==NULL)
	  addToData( (void *)m_pImageY );
	else
	  m_pData->ptr = (void *)m_pImageY;

	computeYBand(m_pImageSequence->currentImage());

      }

      
      //-----
      virtual void nextData(void)
      {	
	m_bDataAvailable=m_pImageSequence->nextImage();
	if(dataAvailable())
	  computeYBand(m_pImageSequence->currentImage());
      }

      
      //-----
      virtual bool dataAvailable(void)
      {
	return m_bDataAvailable;
      }
      	
		
      //-----
      //computes Y band only...
      virtual void computeYBand(ip_Image<ip_ColorElement8u> *pIn)
      {		   
	ip_ColorElement8u color;
	for(int y=0;y<pIn->nbLines();y++)
	{
	  pIn->setLine(y);
	  m_pImageY->setLine(y);
	  for(int x=0;x<pIn->nbColumns();x++)
	  {
	    real data = 0.299*pIn->valueCol(x).one
	      + 0.587*pIn->valueCol(x).two
	      + 0.114*pIn->valueCol(x).three;
	    
	    if( (data-(int)data) <= 0.5 || data > 255.)
	    {
	      color.one = (unsigned char) ((int)data);
	      m_pImageY->setVal(y, x, color);	      
	    }
	    else
	    {
	      color.one = (unsigned char)((int)data + 1);
	      m_pImageY->setVal(y, x, color);				      	      
	    }    
	  }		
	}	
      }
      
      //-----
      virtual ~bi_IpImagesDataRV_Y()
      {}
    };

}

#endif
