#ifndef BI_IPIMAGESDATARV_INC
#define BI_IPIMAGESDATARV_INC

#include "bf_DataRandomVariable.h"
#include "ip_BaseSeqImage.h"

using namespace ImageProcessing;

namespace Torch {

//-----

/** Data random variable that handles ip_Images 
		    
    
    @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
    @author Daniel Gatica-Perez (gatica@idiap.ch)
*/

    class bi_IpImagesDataRV :
    public virtual bf_DataRandomVariable
    {
    public:
      ip_BaseSeqImage<ip_ColorElement8u>    *m_pImageSequence;
      //private:
      bool                                  m_bDataAvailable;

    public:

      ///-----
      bi_IpImagesDataRV(ip_BaseSeqImage<ip_ColorElement8u>    * Seq)
      {
	m_pImageSequence = Seq;
	m_bDataAvailable =false;
      }
      
      //-----
      virtual void initData(void)
      {
	m_bDataAvailable=m_pImageSequence->firstImage();

	if(m_pData==NULL)
	  addToData( (void *)m_pImageSequence->currentImage() );
	else
	  m_pData->ptr=(void *)m_pImageSequence->currentImage();
      }
      
      //-----
      virtual void nextData(void)
      {
	m_bDataAvailable=m_pImageSequence->nextImage();
	if(dataAvailable())
	{
	  if(m_pData==NULL)
	    addToData( (void *)m_pImageSequence->currentImage() );
	  else
	    m_pData->ptr=(void *)m_pImageSequence->currentImage();
	}
      }
      
      //-----
      virtual bool dataAvailable(void)
      {
	return m_bDataAvailable;
      }
      			        
      //-----
      virtual ~bi_IpImagesDataRV(){}
    };

}

#endif
