#ifndef BICV_CONTOUR_MEASURER_INC
#define BICV_CONTOUR_MEASURER_INC

#include "general.h"
#include "ip_Image.h"
#include "ipcv_MultiImage.h"
#include "bi_ShapeTransformTemplate.h"
#include "ipcv_ContourTemplate.h"


// open cv
#include "cv.h"
#include "cvtypes.h"


using namespace ImageProcessing;

namespace Torch {


  class bi_ContourMeasurer : 
    virtual public bi_ShapeTransformTemplate {

  public:
    // computes A SET of 1-D features for a contour object representation
    // that correspond to all the features extracted from the set of
    // normal lines to a contour, as discussed in Blake/Isard
    // the memory for storing and manipulating all these features 
    // exists in ipcv_ContourTemplate

    // return value : whether the measurements are valid
    // (eg. if the object fall outside image range, or the number of
    //  points is too small)
   
    // disabled for the moment 
    virtual bool computeContourMeasurements(IplImage **pImage,
					    ipcv_ContourTemplate *pCT)=0;

    virtual bool computeContourMeasurements(ip_Image <ip_ColorElement8u> *pImage,
					    ipcv_ContourTemplate *pCT)=0;
   
    virtual ~bi_ContourMeasurer() {};

  };


}

#endif // BI_CONTOUR_MEASURER_INC
