#include "general.h"
#include "bf_Trainer.h"


namespace Torch {


  //----- 
  bf_Trainer::bf_Trainer(bf_BayesFilter *pBF, bf_DataRandomVariable *pData)
  {
    m_pBayesFilter = pBF;
    m_pDataInput = pData;
  }
   

  //----- 
  void bf_Trainer::init(long N)
  {
    m_lMaxNumberOfIterations = N;
    m_pBayesFilter->init();
    initData();
  }
  
  //----- 
  void bf_Trainer::initData(void)
  {
    m_pDataInput->initData();
  }
 
  //----- may be redefined at each case
  void bf_Trainer::nextData(void)
  {
    m_pDataInput->nextData();
  }
 
  //----- may be redefined at each case
  bool bf_Trainer::dataAvailable(void)
  {
    return m_pDataInput->dataAvailable();
  }
 

   ////-----
  void bf_Trainer::iterate(void)
  {   
    if (dataAvailable())
      m_pBayesFilter->iterate(m_pDataInput);
  }

  
  ////-----
  void bf_Trainer::iterateN(long N)
  {
    int i;
    if(m_lMaxNumberOfIterations>=0){
      i=0;
      while(i<N && dataAvailable() && i<m_lMaxNumberOfIterations){
	iterate();
	nextData();
	i++;
      }
    }
    else {
      i=0;
      while(i<N && dataAvailable()){
	iterate();
	nextData();
	i++;
      }
    }
  }


  //-----
  bf_Trainer::~bf_Trainer()
  {
  }

}
