#ifndef BF_RANDOMVARIABLE_INC
#define BF_RANDOMVARIABLE_INC

#include "general.h"
#include "List.h"

namespace Torch {

DEFINE_NEW_LIST(ListReal,real);

//-----

/** Provides a basic description of random variable (as a table of pointers 
    on real)
    
    @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
    @author Daniel Gatica-Perez (gatica@idiap.ch)
*/

class bf_RandomVariable
{
  public:

  ListReal  m_cData;
  
  ///
  bf_RandomVariable();
    
  //-----
  
  /** Initialize the random variable
      All objects *MUST* call the #init()#
      function of their parents.
  */
  virtual void init();
    
  //-----

  virtual inline void addToData(ListReal *y);

  virtual inline void addToData(real *ptr, int n=-1);

  //----- cast operator

  //  operator ListRV * () const { return m_pData; }
  operator real * () const { 
    return (real *)m_cData.nodes[0];
  }
  
  //-----

  virtual ~bf_RandomVariable();
};



}

#endif
