#ifndef _BF_PREDICT_MODEL_INC
#define _BF_PREDICT_MODEL_INC

#include "Object.h"
#include "bf_RandomVariable.h"
#include "Vec.h"
#include "Mat.h"
#include "Mat_operations.h"
#include "bf_DistributionReal.h"

namespace Torch {
  //===================================================
  //
  // CLASSES DEFINED HERE :
  /*

    - class bf_PredictModelBase : virtual public Object

    - class bf_PredictModelBaseReal : 
    virtual public  bf_PredictModelBase

     - class bf_SamplePredictModel :
    virtual public  bf_SampleCondDist,
    virtual public   bf_PredictModelBase

    - class bf_SamplePredictModelReal :
    virtual public bf_SamplePredictModel,
    virtual public  bf_SampleCondDistReal,
    virtual public   bf_PredictModelBaseReal


   */

  /**  Models for modeling the dynamics/prediction of states/ 
       
       Updated from :
       * (c) Michael Stevens, Australian Centre for Field Robotics 2000
 
       @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
       @author Daniel Gatica-Perez (gatica@idiap.ch)
  */
    
  
  //===================================================
  //
  //   class     bf_PredictModelBase
  //
  //   Abstract Prediction models
  //   Prediction model are used to parameterise predict 
  //   functions in filters
  //
  //===================================================
  class bf_PredictModelBase : virtual public Object
    {
    public:
      /*
	Xpred =fPredict(X) --> fPredictRV(Xpred,X)
	The memory should be provided for to store the Xpred variable
      */
      virtual void fPredictRV(bf_RandomVariable *pXpred, bf_RandomVariable *pX)=0;
      
    };
  
  
  //===================================================
  //
  //  class      bf_PredictModelBaseReal
  //
  // Abstract Prediction models for reals : same as for Random variable
  //  but with a specific interface for reals
  //
  //===================================================
  class bf_PredictModelBaseReal : 
    virtual public  bf_PredictModelBase
    {
      public :
	
	bf_PredictModelBaseReal() {}
      /*
	Xpred =fPredict(X) --> fPredictRV(Xpred,X)
	The memory should be provided for to store the Xpred variable
      */
      inline virtual void fPredictRV(bf_RandomVariable *pXpred, bf_RandomVariable *pX){
	fPredictReal((real *)pXpred->m_cData.nodes[0],(real *)pX->m_cData.nodes[0]);
      }
      
      virtual void fPredictReal(real  *xpred,real *x)=0;
      
    };
  
 

 //===================================================
 //
 //     class   bf_SamplePredictModel
 // 
 //     xpred=fPredict(x) 
 //     plus, we can sample
 //     x is indeed the conditional of the underlying
 //     distribution
 //
 //===================================================
 class bf_SamplePredictModel :
    virtual public  bf_SampleCondDist,
   virtual public   bf_PredictModelBase
   {
   public:
     bf_SamplePredictModel(bf_RandomGenerator *_rng) :
       bf_SampleDist(_rng){ m_pRng=_rng; }

     bf_SamplePredictModel(){ }
     
     
     virtual ~bf_SamplePredictModel(){}
   };


 //===================================================
 //
 //     class   bf_SamplePredictModelReal
 //
 //     sample = Fpredict(conditional) + 
 //              noise(conditional)
 //     
 //     Thus, we need to provide (at least) :
 //      - sampleConditionalReal
 //      - fPredictReal
 //      - fNoiseReal
 //===================================================
 class bf_SamplePredictModelReal :
   virtual public bf_SamplePredictModel,
   virtual public  bf_SampleCondDistReal,
   virtual public   bf_PredictModelBaseReal
   {
   public:
     // needed for subsequent use in derived classes
     bf_SamplePredictModelReal(){}
     
     bf_SamplePredictModelReal(bf_RandomGenerator *_rng) :
       bf_SamplePredictModel(_rng),
       bf_SampleDist(_rng){ m_pRng=_rng; }
     
      /*
	Xpred =fPredict(X) --> fPredictReal(Xpred,X)
	The memory should be provided for to store the Xpred variable
      */
      virtual void fPredictReal(real  *xpred,real *x)=0;

        // generation of noise, which may depend on the conditional
     virtual void fNoiseReal(real *noise,real *conditional=NULL)=0;

     virtual ~bf_SamplePredictModelReal(){}
   };

 
} //namespace
 
#endif
