#ifndef BF_PARTICLEFILTER_INC
#define BF_PARTICLEFILTER_INC

#include "general.h"
#include "bf_RandomVariable.h"
#include "bf_ParticleDistribution.h"
#include "bf_Distribution.h"
#include "bf_PredictModel.h"
#include "bf_BayesFilter.h"


namespace Torch {

//-----

/** Implements the basic particle filter (condensation)

    @author Jean-Marc Odobez (Jean-Marc.Odobez@idiap.ch)
    @author Daniel Gatica-Perez (gatica@idiap.ch)
*/

  class bf_ParticleFilter : public bf_BayesFilter 
  {
    
    public:
      
    //members (changes after bf_CondDistribution disappeared and was substituted by new hierarchy)

    bf_ParticleDistribution *m_pParticleSet;
    bf_ParticleDistribution *m_pParticleSetAux;
    bf_SamplePredictModel   *m_pDynamicModel;            
    bf_EvalCondDist         *m_pObservationLikelihood;

    //member functions 

    //-----
    bf_ParticleFilter(bf_ParticleDistribution *pPrior, bf_ParticleDistribution *pAux, bf_SamplePredictModel *pDynMod,  bf_EvalCondDist *pObsLike);


    ////////////////////////////////////////////
    // functions inherited from class BayesianFilter
    ////////////////////////////////////////////

    //-----
    virtual void init(void);

    //-----
    //-----assumption: setConditional() has to be used for dynamical model, 
    //      and pars set for likelihood too

    virtual void predict(void);
	    
    //-----
    virtual void observe(bf_RandomVariable *pData);

    //-----
    virtual void update(void);

    //-----
    virtual void iterate(bf_RandomVariable *pData);

    //////////////////////////////////////////////
    //specific member functions of particle filter
    //////////////////////////////////////////////

    virtual void exchange(void);

    virtual void resample(void);

    //-----
    virtual ~bf_ParticleFilter();

  };


}

#endif




