#include "bf_BayesFilter.h"
#include "bf_ParticleFilter.h"


namespace Torch {

  ////-----
  ////----- we assume that the prior was already created and deposited in pPrior, with correct weights
  ////----- also assume that pPrior and pAux are true arrays of RandomVariables
  bf_ParticleFilter::bf_ParticleFilter(bf_ParticleDistribution *pPrior, bf_ParticleDistribution *pAux, bf_SamplePredictModel *pDynMod, bf_EvalCondDist *pObsLike)
  {
    m_pParticleSet = pPrior;
    m_pParticleSetAux =pAux;
    m_pDynamicModel = pDynMod;
    m_pObservationLikelihood = pObsLike;
  }


  ////-----
  void bf_ParticleFilter::init(void)
  {
      m_lCurrentIteration = 0;
  }


  ////----- something has to be set in the dynamical model, and pars set for likelihood too
  ////----- after predict(), the new samples remain in m_pParticleSet

  void bf_ParticleFilter::predict(void)
  {
    bf_RandomVariable *pSampleOld, *pSampleNew;

    for(int i=0; i< m_pParticleSet->m_iNumberOfSamples ; i++)
    { 
      //resample from the prior 
      m_pParticleSet->sampleParticle(&pSampleOld);

      // apply dynamics
      pSampleNew = m_pParticleSetAux->m_pSampleSet[i];
      m_pDynamicModel->sampleConditionalRV(pSampleNew,pSampleOld);
    }

    exchange();

  } // predict()


  ////----- computes weights based on observation likelihood
  ////----- assumption: likelihood parameters have to be set somewhere else 
  ////----- after observe(), the new samples remain in m_pParticleSet

  void bf_ParticleFilter::observe(bf_RandomVariable *pData)
  {
    m_pParticleSet->m_dTotalCumWeight  = 0;
    for(int i=0; i< m_pParticleSet->m_iNumberOfSamples ; i++)
    {
       m_pParticleSet->m_pWeights[i] = m_pObservationLikelihood->evaluateConditionalRV(pData, m_pParticleSet->m_pSampleSet[i]);

	m_pParticleSet->m_pCumWeights[i] = m_pParticleSet->m_dTotalCumWeight;
	m_pParticleSet->m_dTotalCumWeight += m_pParticleSet->m_pWeights[i];
    }	  

  } // observe()


  ////----- this function is left open for other particle filters 
  void bf_ParticleFilter::update(void)
  {
  }

  ////----- Performs a full iteration of filtering,
  ////----- with the date that are provided
  ////----- 

  void bf_ParticleFilter::iterate(bf_RandomVariable *pData){
    predict();
    update();
    observe(pData);
    update();
    resample();
    m_lCurrentIteration++;
  }



  //////////////////////////////////////////////
  //specific member functions of particle filter
  //////////////////////////////////////////////

  void bf_ParticleFilter::exchange(void)
  {
    // exchange pointers between prior and posterior
    bf_ParticleDistribution *pTemp;	  
    pTemp = m_pParticleSet;
    m_pParticleSet = m_pParticleSetAux;
    m_pParticleSetAux = pTemp;

  }  // exchange()     


  void bf_ParticleFilter::resample(void)
  {
  }


  //-----
  bf_ParticleFilter::~bf_ParticleFilter()
  {
  }

}

