#include "bf_LikelihoodProduct.h"

namespace Torch {
  //-----

  /** 

      
    
      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */
  //===================================================
  //
  //    class         bf_LikelihoodProduct
  //
  //    p(Z|X) = Prod_i  ( p_i ( Z | X ) )
  //
  //===================================================

  //-----
  bf_LikelihoodProduct::bf_LikelihoodProduct(bf_EvalCondDist  **pLikelihoods,
					     int               *pDataItem,
					     int               NumberOfLikelihoods){
    create(pLikelihoods,pDataItem,NumberOfLikelihoods);
  }

  //----
  void  bf_LikelihoodProduct::create(bf_EvalCondDist  **pLikelihoods,
				     int               *pDataItem,
				     int               NumberOfLikelihoods){
    int i;
    m_pLikelihood=pLikelihoods;
    m_iNumberOfLikelihoods=NumberOfLikelihoods;
    m_pObservationData=new int [NumberOfLikelihoods];
    for(i=0;i<m_iNumberOfLikelihoods;i++)
      m_pObservationData[i]=pDataItem[i];
    float f;
    m_cZ.addToData(&f); // just to add/have one item in the list of data
  }

  //----
  void  bf_LikelihoodProduct::freeMemory(){
    delete [] m_pObservationData;
  }
    
  //----
  bf_LikelihoodProduct::~bf_LikelihoodProduct(){
    freeMemory();
  }
   
}

