#include "bf_DynamicModel.h"
#include "Mat_operations.h"
#include "mx_low_level.h"

namespace Torch {

  //===================================================
  //
  //  class  bf_AdditivePredictModelReal
  //
  //  a simple model for which the noise is in the 
  //  form of 
  //             G(k) x  q(k)
  //
  //===================================================
  bf_AdditivePredictModelReal::bf_AdditivePredictModelReal(int x_size, int q_size,bf_RandomGenerator *_rng=NULL) :
    bf_SamplePredictModelReal(_rng), q(q_size), 
    G(x_size, q_size),m_vecNoise(q_size),m_vecBaseNoise(q_size)
  {
    m_pRng=_rng;
    q.zero(); G.zero();
    m_vecNoise.zero(); m_vecBaseNoise.zero();
  };

  //--------
  bf_AdditivePredictModelReal::bf_AdditivePredictModelReal(Mat *_G,Vec *_q,bf_RandomGenerator *_rng=NULL) :
    bf_SamplePredictModelReal(_rng),  
    q(_q->n), G(_G->m,_G->n),m_vecNoise(_q->n),m_vecBaseNoise(_q->n)
  {
    m_pRng=_rng;
    if(_G->n != _q->n){
      printf("Error : dimension of matrices for AdditivePredictModel do not match\n");
      exit(0);
    }
    G.copy(_G); q.copy(_q);
    m_vecNoise.zero(); m_vecBaseNoise.zero();
  }


  //--------
  void bf_AdditivePredictModelReal::fNoiseReal(real *noise,real *cond){
    int i;
    Vec Vnoise(noise,G.m);
    m_pRng->set();
    for(i=0;i<q.n;i++)
      m_vecBaseNoise.ptr[i]=m_pRng->gaussian_01()*sqrt(q.ptr[i]);
    m_pRng->release();
    mxMatMulVec(&G,&m_vecBaseNoise,&Vnoise);
  };

  
  //--------
  void bf_AdditivePredictModelReal::sampleConditionalReal(real *sample, real *x){
    real *p=x;
    if(x==NULL)
      p=getConditionalReal();
    fNoiseReal(m_vecNoise.ptr);
    fPredictReal(sample,p);
    mxAdd__(sample,m_vecNoise.ptr,sample,G.m);
  }


  //===================================================
  //
  //  class   bf_LinrzPredictModel
  //
  //===================================================
  //--------
  /*
   * Set the size of things we know about
   */
  bf_LinrzPredictModelReal::bf_LinrzPredictModelReal(int x_size, int q_size,bf_RandomGenerator *_rng) :
    bf_AdditivePredictModelReal(x_size, q_size,_rng),
    Fx(x_size,x_size)
  {
    m_pRng=_rng;
    Fx.zero();
  };
  
  //--------
  bf_LinrzPredictModelReal::bf_LinrzPredictModelReal(Mat *_G,Vec *_q,Mat *_Fx,bf_RandomGenerator *_rng) : 
    bf_AdditivePredictModelReal(_G,_q,_rng),
    Fx(_Fx->m,_Fx->m)
  {
    m_pRng=_rng;
    if(_Fx->m!=_Fx->n || _Fx->m != _G->m){
      printf("Error : dimension of matrices for LinrzPredictModel do not match\n");
      exit(0);
    }
    Fx.copy(_Fx);
  };
  
  //===================================================
  //
  //   class   bf_LinearPredictModel
  //
  //===================================================
  //--------
  bf_LinearPredictModelReal::bf_LinearPredictModelReal(int x_size, int q_size,bf_RandomGenerator *_rng) :
    /*
     * Set the size of things we know about
     */
    bf_LinrzPredictModelReal(x_size, q_size,_rng)
  {
    m_pRng=_rng;
  };

  //--------
  bf_LinearPredictModelReal::bf_LinearPredictModelReal(Mat *_G,Vec *_q,Mat *_Fx,bf_RandomGenerator *_rng ) :
    bf_LinrzPredictModelReal(_G,_q,_Fx,_rng)
  {  m_pRng=_rng; };

  //--------
  void bf_LinearPredictModelReal::fPredictReal(real *xpred, real *x){
    // Provide a linear implementation of functional f assumes model is already Linrz for Fx
    Vec    vxpred(xpred,Fx.m),vx(x,Fx.m);
    mxMatMulVec(&Fx,&vx, &vxpred);
  }




}  // namsapce Torch
