#ifndef BF_DISTRIBUTION_REAL_INC
#define BF_DISTRIBUTION_REAL_INC

#include "general.h"
#include "bf_RandomVariable.h"
#include "bf_RandomGenerator.h"
#include "bf_Distribution.h"

namespace Torch {
  //-----

  /** 
      Same as bf_Distribution, but work on vectors of reals.

      Provides a basic description of distribution that 
      work on reals (all members functions ends with Real)
      
      Important : can also be used with random variables
      (compatibility is ensured)

      Name : bf_FuncTypeReal
      
      P(X)  (Type = Dist)   or P(X|Y) (Type = CondDist)

      Distribution are named according to what they
      provide :
      Func=Eval   -----> distribution that can be evaluated
      Func=Sample -----> distribution that can be sampled
      Func=EvalSample -> distribution that can be evaluated and sampled
      
    
      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */


  //===================================================
  //
  // class       bf_EvalDistReal 
  //
  //===================================================
  class bf_EvalDistReal : 
    virtual public bf_EvalDist {

  public:

    //dgp: there was no constructor!
    bf_EvalDistReal() {}

    virtual real evaluateReal(real *pX)=0;

    virtual real evaluateRV(bf_RandomVariable *pX);

    virtual ~bf_EvalDistReal(){}
  };


  //===================================================
  //
  //  class      bf_SampleDistReal
  //
  //===================================================
  class bf_SampleDistReal :
    virtual public bf_SampleDist 
    {
    public:
      bf_SampleDistReal(bf_RandomGenerator *_rng) :
	bf_SampleDist(_rng) 
	{
	  m_pRng=_rng; // for safety
	};

      bf_SampleDistReal() { }

      //---
      virtual void sampleReal(real *pX)=0;

      virtual void sampleRV(bf_RandomVariable *pX);

      virtual void sampleReal_N(real **pX,int N=1);

      virtual ~bf_SampleDistReal(){}
    };

  //===================================================
  //
  // class       bf_EvalSampleDistReal
  //
  //===================================================
  class bf_EvalSampleDistReal : 
    virtual public bf_EvalDistReal,
    virtual public bf_SampleDistReal,
    virtual public bf_EvalSampleDist
    {
    public:
      ///-------
      // Not a good thing, but just to avoid all
      // direct and undirect derived class to call 
      // the constructor with random generator
      bf_EvalSampleDistReal() {      }
      
      bf_EvalSampleDistReal(bf_RandomGenerator *_rng) :
	bf_SampleDistReal(_rng) 
	{	  m_pRng=_rng; // for safety
	};

      // virtual real evaluateReal(real *pX)=0;
      // virtual void sampleReal(real *pX)=0;
      
      virtual ~bf_EvalSampleDistReal(){}
    };

  //===================================================
  //
  // class       bf_ConditionalReal
  //
  //===================================================
  class bf_ConditionalReal :
    virtual public bf_Conditional {

  private:
     bf_RandomVariable  *m_pConditionalReal;

  public:
    bf_ConditionalReal();

    // setting Conditional  to Y
    virtual inline void setConditionalRV(bf_RandomVariable *pY);

    // getting Conditional 
    virtual inline bf_RandomVariable *getConditionalRV();
    
    // setting Conditional  to Y
    virtual inline void setConditionalReal(real *pY);
    
    // getting Conditional
    virtual inline real *getConditionalReal();

    virtual ~bf_ConditionalReal();

  };   

  //===================================================
  //
  //  class        bf_EvalCondDistReal
  //
  //===================================================
  class bf_EvalCondDistReal : 
    virtual public bf_EvalCondDist,
    virtual public bf_EvalDistReal,
    virtual public bf_ConditionalReal
    // public bf_Conditional
    {
    public:
      bf_EvalCondDistReal() 
	{}

      // computing P ( X | Y )
      virtual real evaluateConditionalRV(bf_RandomVariable *pX,
					 bf_RandomVariable *pY=NULL);

      // 
      virtual real evaluateConditionalReal(real *pX,
					   real *pY=NULL)=0;

      // computing P ( X | stored conditional  )
      virtual real evaluateRV(bf_RandomVariable *pX);

      // computing P ( X | stored conditional  )
      virtual real evaluateReal(real *pX);

     
      virtual ~bf_EvalCondDistReal(){}

    };

  //===================================================
  //
  // class          bf_SampleCondDistReal
  //
  //===================================================
  class bf_SampleCondDistReal : 
    virtual public bf_SampleDistReal,
    virtual public bf_SampleCondDist,
    virtual public bf_ConditionalReal
    {
    public:
      bf_SampleCondDistReal(bf_RandomGenerator *_rng)  {m_pRng = _rng; };

      bf_SampleCondDistReal()  {};


      // sampling P ( X | Y )
      virtual void sampleConditionalRV(bf_RandomVariable *pX,
				       bf_RandomVariable *pY=NULL);

       // sampling P ( X | Y )
      virtual void sampleConditionalReal(real *pX,real *pY=NULL)=0;

     // sampling P ( X | Y )
      virtual void sampleRV(bf_RandomVariable *pX);

     // sampling P ( X | Y )
      virtual void sampleReal(real *pX);
 
      //
      virtual ~bf_SampleCondDistReal(){}

    };

  //===================================================
  //
  //    class       bf_EvalSampleCondDistReal
  //
  //===================================================
  class bf_EvalSampleCondDistReal : 
    virtual public bf_SampleCondDistReal,
    virtual public bf_EvalCondDistReal,
    virtual public bf_EvalSampleDistReal,
    virtual public bf_EvalSampleCondDist
    {

    public:
      bf_EvalSampleCondDistReal(bf_RandomGenerator *_rng) :
	bf_SampleDist(_rng) {};

      bf_EvalSampleCondDistReal() {}
      
      // sampling P ( X | Y )
      virtual void sampleConditionalReal(real *pX, real *pY=NULL)=0;
      
      // computing P ( X | Y )
      virtual real evaluateConditionalReal(real *pX,real *pY=NULL)=0;

      //
      virtual void sampleRV(bf_RandomVariable *pX);
      virtual real evaluateRV(bf_RandomVariable *pX);

      // 
      virtual ~bf_EvalSampleCondDistReal(){}

    };

   
}

#endif
