#ifndef BF_BAYESFILTER_INC
#define BF_BAYESFILTER_INC

#include "general.h"
#include "bf_RandomVariable.h"


namespace Torch {

//-----

/** Provides the interface for Bayes Filters,
    that implement one step of the recursion

    p(X_t | {\cal Z}_t) \propto  p(Z_t | X_t) p(X_t | {\cal Z}_t-1 )

    which includes Kalman filter and sequential
    Monte Carlo (aka particle) filters.

    (The iterations will be done by bf_BayesTrainer)

    @author Jean-Marc Odobez (Jean-Marc.Odobez@idiap.ch)
    @author Daniel Gatica-Perez (gatica@idiap.ch)
*/

  class bf_BayesFilter 
  {
    
    public:
      
    //members

    //time status of the filter
    long m_lCurrentIteration;


    //member functions 

    //-----
    bf_BayesFilter();

    //-----
    virtual void init(void) = 0;

    //-----
    virtual void predict(void) = 0;
	    
    //-----
    virtual void observe(bf_RandomVariable *pData) = 0;

    //-----
    virtual void update(void) = 0;

    //-----
    virtual void iterate(bf_RandomVariable *pData) = 0;

    //-----
    virtual ~bf_BayesFilter();

  };


}

#endif
